* Definicia indexovych mnozin
Sets i /GS,PR,PF,W,NT,E,G,HH,CAP,F/
     m /1*2/;

     alias(j,i)
     alias(m,m1)

Set  subi1(i) /PR/
     subj1(j) /NT/
     subi2(i) /NT/
     subj2(j) /G/
     subi3(i) /F/
     subj3(j) /CAP/;

Parameters A0(i,j)
           B0(i,j) SAM Year '95,
           X0(j)   column & row sum '95
           A1(i,j)
           B1(i,j) SAM Year '96,
           X1(j)   column & row sum '96;

$libinclude xlimport B0 c:\MaxEnt\Data\SAM-95-96.xls data!b4:l14
$libinclude xlimport B1 c:\MaxEnt\Data\SAM-95-96.xls data!b24:l34
$libinclude xlimport X0 c:\MaxEnt\Data\SAM-95-96.xls data!c16:l17
$libinclude xlimport X1 c:\MaxEnt\Data\SAM-95-96.xls data!c36:l37

    B0(i,j)=B0(i,j)/1000;
    B1(i,j)=B1(i,j)/1000;
    x0(j)=x0(j)/1000;
    x1(j)=x1(j)/1000;

    A1(i,j)=B1(i,j)/X1(j);

Scalar SH1,SH2;
   SH1=1;
   SH2=SH1*X1('F');

   X1('NT')=x1('NT')+SH2;
   X1('PR')=x1('PR')+SH2;
   X1('NT')=x1('NT')+SH2;
   X1('G')=x1('G')+SH2;
   X1('F')=x1('F')+SH2;
   X1('CAP')=x1('CAP')+SH2;

   B0('NT','PR')=B0('NT','PR')+SH2;
   B0('PR','NT')=B0('PR','NT')+SH2;
   B0('G','NT')=B0('G','NT')+SH2;
   B0('NT','G')=B0('NT','G')+SH2;
   B0('CAP','F')=B0('CAP','F')+SH2;
   B0('F','CAP')=B0('F','CAP')+SH2;

   X0(j)=sum(i, B0(i,j));

Scalar G0,G1,N1,N5,F;
    G0=sum(j, X0(j));
    G1=sum(j, X1(j));
    N1=sum((i,j), 1);
    N5=sum(m, 1);

    F=1;
    G1=G1/F;

    X1(j)=X1(j)/F;

Parameter C0(i,j);
    C0(i,j)=B0(i,j)/G0;

Parameter Z_ALT(i,j,m);
    Z_ALT(i,j,'1') = 0;
    Z_ALT(i,j,'2') = 1;

Parameter N4(i,j);
    N4(i,j)=sum(m$(Z_ALT(i,j,m) ne 0), 1);

Parameter Q_ALT(i,j,m);
    Q_ALT(i,j,'1')=(Z_ALT(i,j,'2')-C0(i,j))/(Z_ALT(i,j,'2')-Z_ALT(i,j,'1'));
    Q_ALT(i,j,'2')=1-Q_ALT(i,j,'1');

Variables
    lambda(i)
    mi(j)
    gamma(i,j)
    ni1
    ni2
    ni3
    KL       cross-entropy;

Equations
    obj_alt    define objective function - alternative ;

    obj_alt..    KL =e= sum(i, lambda(i)*x1(i))
                      + sum(j, mi(j)*x1(j))
                      + ni1*SH2
                      + ni2*SH2
                      + ni3*SH2
                      + sum((i,j)$(N4(i,j) = N5), gamma(i,j))
                      - log(sum((i,j,m)$(Z_ALT(i,j,m) ne 0),
                                            Q_ALT(i,j,m)*Z_ALT(i,j,m)*
                                                 exp(lambda(i)*G1+mi(j)*G1
                                                     +ni1$(subi1(i) and subj1(j))*G1
                                                     +ni2$(subi2(i) and subj2(j))*G1
                                                     +ni3$(subi3(i) and subj3(j))*G1
                        +(gamma(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))));

Model SAM_ALT /obj_alt/ ;

option NLP=CONOPT2;

Parameters omega,p(i,j,m),
           A1_HAT(i,j),B1_HAT(i,j);

    lambda.l(i)=0;
    mi.l(j)=0;
    gamma.l(i,j)=0;
    ni1.l=0;
    ni2.l=0;
    ni3.l=0;

Solve SAM_ALT using NLP maximizing KL;

    omega=sum((i,j,m)$(Z_ALT(i,j,m) ne 0), Q_ALT(i,j,m)*Z_ALT(i,j,m)*exp(lambda.l(i)*G1+mi.l(j)*G1
                                                     +ni1.l$(subi1(i) and subj1(j))*G1
                                                     +ni2.l$(subi2(i) and subj2(j))*G1
                                                     +ni3.l$(subi3(i) and subj3(j))*G1
                                            +(gamma.l(i,j)/abs(Z_ALT(i,j,m)))$(N4(i,j) = N5)));
    p(i,j,m)$(Z_ALT(i,j,m) ne 0)=Q_ALT(i,j,m)*exp(lambda.l(i)*G1+mi.l(j)*G1
                                                     +ni1.l$(subi1(i) and subj1(j))*G1
                                                     +ni2.l$(subi2(i) and subj2(j))*G1
                                                     +ni3.l$(subi3(i) and subj3(j))*G1
                              +(gamma.l(i,j)/abs(Z_ALT(i,j,m)))$(N4(i,j) = N5))/omega;
    p(i,j,m)$(Z_ALT(i,j,m) = 0)=1-sum(m1, p(i,j,m1)$(Z_ALT(i,j,m1) ne 0));
    A1_HAT(i,j)=sum(m, Z_ALT(i,j,m)*p(i,j,m))*G1/X1(j);
    B1_HAT(i,j)=A1_HAT(i,j)*x1(j)*F;

   x1(j)=x1(j)*F;

   B1_HAT('NT','PR')=B1_HAT('NT','PR')-SH2;
   B1_HAT('PR','NT')=B1_HAT('PR','NT')-SH2;
   B1_HAT('G','NT')=B1_HAT('G','NT')-SH2;
   B1_HAT('NT','G')=B1_HAT('NT','G')-SH2;
   B1_HAT('CAP','F')=B1_HAT('CAP','F')-SH2;
   B1_HAT('F','CAP')=B1_HAT('F','CAP')-SH2;

   x1('NT')=x1('NT')-SH2;
   x1('PR')=x1('PR')-SH2;
   x1('NT')=x1('NT')-SH2;
   x1('G')=x1('G')-SH2;
   x1('F')=x1('F')-SH2;
   x1('CAP')=x1('CAP')-SH2;

   A1_HAT(i,j)=B1_HAT(i,j)/X1(j);
   B1_HAT(i,j)=B1_HAT(i,j)*1000;
$libinclude xlexport B1_HAT C:\MaxEnt\Data\SAM-95-96.xls ALT!c4:m14
   B1_HAT(i,j)=B1_HAT(i,j)/1000;

Parameter  E_A(i,j),E_B(i,j),P_B(i,j);

       E_A(i,j) = A1_HAT(i,j)-A1(i,j);
       E_B(i,j) = B1_HAT(i,j)-B1(i,j);
       P_B(i,j)$B1(i,j) = abs(E_B(i,j))/B1(i,j);

Parameter MAD_A,SEM_A,MAD_B,SEM_B,
          MaxPE,MAPE,GOF_A,GOF_B,
          CORR_A,CORR_B,
          mean_A1_HAT,mean_A1,
          mean_B1_HAT,mean_B1,
          mean0,mean1,
          stddev0,stddev1;

       MAD_A = sum((i,j), abs(E_A(i,j)))/N1;
       SEM_A = sum((i,j), power(E_A(i,j),2))/N1;

       MAD_B = sum((i,j), abs(E_B(i,j)))/N1;
       SEM_B = sum((i,j), power(E_B(i,j),2))/N1;

       MaxPE = smax((i,j), P_B(i,j));
       MAPE = sum((i,j), P_B(i,j))/N1;

       GOF_A = sum((i,j)$A1_HAT(i,j), abs(power(E_A(i,j),2)/(N1*A1_HAT(i,j))));
       mean_A1_HAT = sum((i,j), A1_HAT(i,j))/N1;
       mean_A1 = sum((i,j), A1(i,j))/N1;
       CORR_A = (sum((i,j),(A1_HAT(i,j)-mean_A1_HAT)*(A1(i,j)-mean_A1))/N1)/
         (((sum((i,j),power(A1_HAT(i,j)-mean_A1_HAT,2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5);

       GOF_B = sum((i,j)$B1_HAT(i,j), abs(power(E_B(i,j),2)/(N1*B1_HAT(i,j))));
       mean_B1_HAT=sum((i,j), B1_HAT(i,j))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B = (sum((i,j),(B1_HAT(i,j)-mean_B1_HAT)*(B1(i,j)-mean_B1))/N1)/
         (((sum((i,j),power(B1_HAT(i,j)-mean_B1_HAT,2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5);

       mean0=sum((i,j), B0(i,j))/N1;
       mean1=sum((i,j), B1(i,j))/N1;
       stddev0=sum((i,j), power((B0(i,j)-mean0),2))/N1;
       stddev1=sum((i,j), power((B1(i,j)-mean1),2))/N1;

option decimals = 5

Display MAD_A,SEM_A,
        MAD_B,SEM_B,
        MaxPE,MAPE,
        GOF_A,GOF_B,
        CORR_A,CORR_B,
        stddev0,stddev1;

display b1_hat;